/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
Mesh mbox ,
     mball;
/******************************************************************************

   In this tutorial we'll dynamically show different Bump Mapping modes
   Changing Bump Mapping modes in runtime requires reseting shader effects of manually created Meshes
   To achieve this we need to create a function which will reset effects of those meshes:

/******************************************************************************/
void SetEffect()
{
   mbox .setEffect();
   mball.setEffect();
}
/******************************************************************************/
void InitPre()
{
   App.name="Rendering Bumpmapping";
   App.flag=APP_MS_EXCLUSIVE|APP_FULL_TOGGLE;
   PakAdd("../data/engine.pak");

   D.set_effect=SetEffect          ; // set 'SetEffect' function to be used when needed
   D.full(true).bumpMode(BUMP_FLAT); // start with flat bump mapping
}
/******************************************************************************/
Bool Init()
{
   Cam.dist=3;

   Material *material=Materials("../data/mtrl/brick/0.mtrl");

   mbox .create(1).B(0).create( Box(4),VTX_TX0|VTX_NRM|VTX_TNG).reverse(); // create mesh box, reverse it because it's meant to be viewed from inside
   mball.create(1).B(0).create(Ball(1),VTX_TX0|VTX_NRM|VTX_TNG)          ; // create mesh ball

   // set mesh materials, rendering versions and bounding boxes
   mbox .setMaterial(material).setRender().setBox();
   mball.setMaterial(material).setRender().setBox();

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   CamHandle(0.1,10,CAMH_ZOOM|(Ms.b(1)?CAMH_MOVE:CAMH_ROT)); // move camera on right mouse button

   // change bump mapping when keys pressed
   if(Kb.bp(KB_1))D.bumpMode(BUMP_FLAT    );
   if(Kb.bp(KB_2))D.bumpMode(BUMP_NORMAL  );
   if(Kb.bp(KB_3))D.bumpMode(BUMP_PARALLAX);
   if(Kb.bp(KB_4))D.bumpMode(BUMP_RELIEF  );
   return true;
}
/******************************************************************************/
void Render()
{
   switch(Renderer())
   {
      case RM_SOLID:
         mbox .draw(MatrixIdentity);
         mball.draw(MatrixIdentity);
      break;

      case RM_LIGHT:
         LightPoint(25,Vec(0,3,0)).add();
      break;
   }
}
void Draw()
{
   Renderer(Render);
   D.text(0,0.9,S+"Fps "+Tm.fps);
   D.text(0,0.8,"Press 1,2,3,4 keys for different Bumpmapping modes");
}
/******************************************************************************/
